/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.GraphicPanelProducer;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.Log;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.lspeed.LsBoxInfo;
import ibm.nways.lspeed.LsModuleView;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class LsGraphic {
    private static ResourceBundle lspeedBundle;
    protected static final String PropertiesFile = "properties/lspeed.txt";
    protected static final String layoutKey = "layout.scheme";
    protected static final String fractKey = "layout.fractions";
    protected static final int IconXpos = 32;
    protected static final int SlotXpos = 0;
    private JdmBrowser lsBrowser;
    private LsBoxInfo boxInfo;
    private GenModel lsModule_model;
    private GenModel lsAtmModule_model;
    private boolean completePicture;
    public boolean isApplication;
    public boolean loggingOn;

    public LsGraphic(JdmBrowser jdmBrowser, LsBoxInfo lsBoxInfo, boolean bl) {
        block11: {
            ModelInfo modelInfo;
            int n;
            Vector vector;
            block10: {
                this.loggingOn = false;
                this.isApplication = jdmBrowser.getIsApplication();
                if (this.isApplication) {
                    this.loggingOn = Log.getLog().getLoggingState();
                }
                if (this.loggingOn) {
                    System.out.println("LS:LsGraphic  constructor");
                }
                lspeedBundle = ResourceBundle.getBundle("ibm.nways.lspeed.LsGeneralResources");
                this.lsBrowser = jdmBrowser;
                this.boxInfo = lsBoxInfo;
                this.lsModule_model = this.boxInfo.getLsModel("LsModule");
                this.lsAtmModule_model = this.boxInfo.getLsModel("LsAtmModule");
                try {
                    if (this.lsModule_model != null) {
                        vector = this.lsModule_model.getRestOfInfo("ModuleInfo", "default", null, null);
                        n = 0;
                        while (n < vector.size()) {
                            modelInfo = (ModelInfo)vector.elementAt(n);
                            modelInfo.flagAsMonitored();
                            this.lsModule_model.setInfo("ModuleInfo", modelInfo);
                            ++n;
                        }
                    }
                }
                catch (Exception exception) {
                    if (!this.loggingOn) break block10;
                    System.out.println("LS:Failed to get LsModuleInfo");
                    exception.printStackTrace();
                }
            }
            try {
                if (this.lsAtmModule_model != null) {
                    vector = this.lsAtmModule_model.getRestOfInfo("ModuleInfo", "default", null, null);
                    n = 0;
                    while (n < vector.size()) {
                        modelInfo = (ModelInfo)vector.elementAt(n);
                        modelInfo.flagAsMonitored();
                        this.lsAtmModule_model.setInfo("ModuleInfo", modelInfo);
                        ++n;
                    }
                    return;
                }
            }
            catch (Exception exception) {
                if (!this.loggingOn) break block11;
                System.out.println("LS:Failed to get LsModuleInfo");
                exception.printStackTrace();
            }
        }
    }

    protected GraphicPanel getGraphicPanel() {
        Object object;
        int n;
        Object object2;
        Object object3;
        int n2;
        Properties properties;
        Serializable serializable;
        new Panel();
        int n3 = 0;
        int n4 = 75;
        if (this.isApplication) {
            this.loggingOn = Log.getLog().getLoggingState();
        }
        if (this.loggingOn) {
            System.out.println("LS:LsGraphic.getGraphicPanel  entry");
        }
        try {
            serializable = new URL(this.lsBrowser.getDocumentBase(), PropertiesFile);
            properties = new Properties();
            properties.load(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            if (this.loggingOn) {
                System.out.println("LS:Error getting Lspeed Properties: " + exception.getMessage());
            }
            properties = null;
            exception.printStackTrace();
        }
        JdmLayout jdmLayout = (JdmLayout)this.lsBrowser.getLayout();
        if (properties != null) {
            serializable = new Integer((String)((Hashtable)properties).get(layoutKey));
            if (this.loggingOn) {
                System.out.println("LS:The layout scheme prpt = " + serializable);
            }
            n2 = (Integer)serializable;
            jdmLayout.setScheme(n2);
            object3 = (String)((Hashtable)properties).get(fractKey);
            object2 = new StringTokenizer((String)object3);
            float[] fArray = new float[((StringTokenizer)object2).countTokens()];
            n = 1;
            int n5 = 0;
            while (n5 < fArray.length && ((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                try {
                    fArray[n5] = Float.valueOf((String)object).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.loggingOn) {
                        System.out.println("LS:Bad layout.fractions parm(" + numberFormatException.getMessage() + ")");
                    }
                    n = 0;
                }
                ++n5;
            }
            if (n != 0) {
                jdmLayout.setFracts(fArray);
            }
        } else {
            n2 = 1;
            jdmLayout.setScheme(n2);
        }
        GraphicContainer graphicContainer = new GraphicContainer();
        serializable = new GraphicHelp(this.lsBrowser, new Point(0, 0), new HelpRef(this));
        graphicContainer.add((GraphicComponent)serializable);
        object3 = new Label("SLOT");
        ((Component)object3).setLocation(new Point(0, 45));
        graphicContainer.add((Component)object3);
        object2 = this.boxInfo.getLsModuleList();
        int n6 = this.boxInfo.getMaxNumOfSlots();
        n = 1;
        while (n < n6) {
            NavigationDestination navigationDestination = new NavigationDestination("ibm.nways.lspeed.LsModulePanel", this.lsModule_model);
            object = new NavigationDestination("ibm.nways.lspeed.LsAtmModulePanel", this.lsAtmModule_model);
            Integer n7 = new Integer(n);
            if (((Hashtable)object2).get(n7) != null) {
                StatusProxy statusProxy;
                Object object4;
                int n8 = (Integer)((Hashtable)object2).get(n7);
                ModelInfo modelInfo = new ModelInfo();
                modelInfo.add("Index.Slot", n7);
                modelInfo.add("Index.SubSlot", new Integer(1));
                Object object5 = null;
                try {
                    RemoteStatus remoteStatus;
                    if (n8 == 21) {
                        object5 = object;
                        remoteStatus = this.lsAtmModule_model.getStatusRefForRow(modelInfo);
                    } else {
                        object5 = navigationDestination;
                        remoteStatus = this.lsModule_model.getStatusRefForRow(modelInfo);
                    }
                    object4 = new LsModuleView(n7);
                    ((NavigationDestination)object5).setGraphicPanelProducer((GraphicPanelProducer)object4);
                    statusProxy = new StatusProxy(remoteStatus);
                }
                catch (Exception exception) {
                    if (this.loggingOn) {
                        exception.printStackTrace();
                    }
                    statusProxy = null;
                }
                object4 = new NavigationContext();
                ((NavigationContext)object4).setParent(this.lsBrowser.getNavigationTree().getNavContext());
                NavInitialRow.setInitialRow((NavigationContext)object4, modelInfo);
                GraphicImage graphicImage = new GraphicImage(this.lsBrowser.imageFrom(this, LsBoxInfo.iconGifs[n8]), new Point(32, n3 += n4), 4, new GraphicActionNavigate(this.lsBrowser, (NavigationDestination)object5, (NavigationContext)object4), statusProxy);
                GraphicFlyOver graphicFlyOver = new GraphicFlyOver(String.valueOf(LsBoxInfo.ModuleDescr[n8]) + " Switching Module");
                graphicImage.setFlyOver(graphicFlyOver);
                graphicContainer.add(graphicImage);
                Label label = new Label(n7.toString(), 1);
                label.setLocation(new Point(0, n3 + 12));
                graphicContainer.add(label);
                Label label2 = new Label(LsBoxInfo.LsTypesExt[n8]);
                label2.setLocation(new Point(32, n3 + 40));
                graphicContainer.add(label2);
            }
            ++n;
        }
        GraphicPanel graphicPanel = new GraphicPanel(this.lsBrowser, graphicContainer);
        return graphicPanel;
    }
}

